<?php
// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Get the fingerprint from URL parameters, default to empty string if not provided
    $fingerprint = $_GET['fingerprint'] ?? '';
    
    // Proceed if fingerprint is not empty
    if ($fingerprint) {
        // Read the contents of the log file containing fingerprint records
        $logContents = file_get_contents('fingerprints.log');
        // Split the log file into individual lines
        $lines = explode("\n", $logContents);
        // Initialize variables for tracking match status and associated name
        $found = false;
        $name = '';
        
        // Loop through each line in the log
        foreach ($lines as $line) {
            // Check if current line contains the requested fingerprint
            if (strpos($line, "Fingerprint: $fingerprint") !== false) {
                $found = true;
                // Extract the name associated with the fingerprint using regex
                // Format expected: "Name: something"
                preg_match('/Name: (.+)$/', $line, $matches);
                // Get the captured name, default to empty string if not found
                $name = $matches[1] ?? '';
                // Exit loop once match is found
                break;
            }
        }
        
        // Return JSON response with recognition status and name
        echo json_encode(['recognized' => $found, 'name' => $name]);
    } else {
        // Return 400 Bad Request if fingerprint parameter is missing
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Missing fingerprint']);
    }
} else {
    // Return 405 Method Not Allowed if request method is not GET
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
}
?>