<?php
// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   // Get name and fingerprint from POST data, default to empty string if not provided
   $name = $_POST['name'] ?? '';
   $fingerprint = $_POST['fingerprint'] ?? '';
   
   // Proceed if both name and fingerprint are provided
   if ($name && $fingerprint) {
       // Create a log entry with timestamp, fingerprint and name
       $logEntry = date('Y-m-d H:i:s') . " - Fingerprint: $fingerprint, Name: $name\n";
       // Append the entry to the log file
       file_put_contents('fingerprints.log', $logEntry, FILE_APPEND);
       // Return success response
       echo json_encode(['success' => true]);
   } else {
       // Return 400 Bad Request if name or fingerprint is missing
       http_response_code(400);
       echo json_encode(['success' => false, 'error' => 'Missing name or fingerprint']);
   }
} else {
   // Return 405 Method Not Allowed if request method is not POST
   http_response_code(405);
   echo json_encode(['success' => false, 'error' => 'Method not allowed']);
}
?>